package gov.va.med.mhv.mrp.web.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import gov.va.med.mhv.mrp.enums.GoalCompletionTypeEnumeration;
import gov.va.med.mhv.mrp.enums.GoalTaskRepetitionCycleTypeEnum;

public class MyGoalTask implements Serializable {
	private static final long serialVersionUID = 198771056421051174L;

	private Long taskId;
	private Calendar completedDate;
	private Integer taskSequenceNumber;
	private Date startDate;
	private String taskName;
	private String description;
	private Integer taskRepetitionCycleType;
	private Date endDate;
	private Integer status;
	private Calendar startTime;
	private Integer completionType;
	private Calendar endTime;
	private Long goalExtensionId;
	private Integer oplock;
	private Boolean selected; // for goal samples
	private Boolean markCompleted = false; // for view track goals
	private List<MyGoalTaskActivity> myGoalsTaskActivities = new ArrayList<MyGoalTaskActivity>();
	private List<MyGoalsTaskExtensions> myGoalsTaskExtensions = new ArrayList<MyGoalsTaskExtensions>();
	private List<MyGoalTaskActivity> trackTaskActivities = new ArrayList<MyGoalTaskActivity>(); // for view track goals
	
	
	public boolean isScheduled(Calendar startDate, Calendar endDate) {
		Calendar c1 = Calendar.getInstance();
		c1.setTime(startDate.getTime());

		Calendar c2 = Calendar.getInstance();
		c2.setTime(endDate.getTime());

		return (c1.compareTo(startDate) >= 0 && c2.compareTo(endDate) <= 0);
	}

	public Integer getStartHour() {
		return startTime != null ? startTime.get(Calendar.HOUR_OF_DAY) : null;
	}

	public void setStartHour(Integer hour) {
		if (startTime == null) {
			startTime = Calendar.getInstance();
			startTime.set(Calendar.HOUR_OF_DAY, 0);
			startTime.set(Calendar.MINUTE, 0);
		}
		startTime.set(Calendar.HOUR_OF_DAY, hour != null ? hour : 0);

	}

	public Integer getStartMinute() {
		return startTime != null ? startTime.get(Calendar.MINUTE) : null;
	}

	public void setStartMinute(Integer minute) {
		if (startTime == null) {
			startTime = Calendar.getInstance();
			startTime.set(Calendar.HOUR_OF_DAY, 0);
			startTime.set(Calendar.MINUTE, 0);
		}
		startTime.set(Calendar.MINUTE, minute != null ? minute : 0);
	}

	public Integer getEndHour() {
		return endTime != null ? endTime.get(Calendar.HOUR_OF_DAY) : null;
	}

	public void setEndHour(Integer hour) {
		if (endTime == null) {
			endTime = Calendar.getInstance();
			endTime.set(Calendar.HOUR_OF_DAY, 0);
			endTime.set(Calendar.MINUTE, 0);
		}
		endTime.set(Calendar.HOUR_OF_DAY, hour != null ? hour : 0);
	}

	public Integer getEndMinute() {
		return endTime != null ? endTime.get(Calendar.MINUTE) : null;
	}

	public void setEndMinute(Integer minute) {
		if (endTime == null) {
			endTime = Calendar.getInstance();
			endTime.set(Calendar.HOUR_OF_DAY, 0);
			endTime.set(Calendar.MINUTE, 0);
		}
		endTime.set(Calendar.MINUTE, minute != null ? minute : 0);
	}

	public String getCompletionTypeDescription() {
		return GoalCompletionTypeEnumeration.findByCode(completionType).getDescription();
	}

	public String getGoalTaskRepetitionCycleTypeDescription() {
		return GoalTaskRepetitionCycleTypeEnum.findByCode(taskRepetitionCycleType).getDescription();
	}
	
	public void fillTrackTaskActivities(Calendar firstDay) {
		Calendar today = Calendar.getInstance();
		
		if (trackTaskActivities.isEmpty()) {
			for (int i = 0; i <= 6; i++) {
				MyGoalTaskActivity activity = new MyGoalTaskActivity();
				trackTaskActivities.add(activity);	
			}
		}
		
		for (int i = 0; i <= 6; i++) {
			Calendar offset = (Calendar) firstDay.clone();
			offset.add(Calendar.DAY_OF_MONTH, i);
			
			trackTaskActivities.get(i).setOplock(0);
			trackTaskActivities.get(i).setTaskActivityId(0L);
			trackTaskActivities.get(i).setTaskRepetitionCycleType(this.taskRepetitionCycleType);
			trackTaskActivities.get(i).setActivityDate(offset);
			trackTaskActivities.get(i).setSelected(false);
			trackTaskActivities.get(i).setUpdatedTime(today);
		}
		
	}

	public Boolean getCompleted() {
		return completedDate != null;
	}

	public void setCompleted(Boolean completed) {
		completedDate = (completed ? Calendar.getInstance() : null);
	}

	public Long getTaskId() {
		return taskId;
	}

	public void setTaskId(Long taskId) {
		this.taskId = taskId;
	}

	public Calendar getCompletedDate() {
		return completedDate;
	}

	public void setCompletedDate(Calendar completedDate) {
		this.completedDate = completedDate;
	}

	public Integer getTaskSequenceNumber() {
		return taskSequenceNumber;
	}

	public void setTaskSequenceNumber(Integer taskSequenceNumber) {
		this.taskSequenceNumber = taskSequenceNumber;
	}

	public Date getStartDate() {
		return startDate;
	}

	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

	public String getTaskName() {
		return taskName;
	}

	public void setTaskName(String taskName) {
		this.taskName = taskName;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public Integer getTaskRepetitionCycleType() {
		return taskRepetitionCycleType;
	}

	public void setTaskRepetitionCycleType(Integer taskRepetitionCycleType) {
		this.taskRepetitionCycleType = taskRepetitionCycleType;
	}

	public Date getEndDate() {
		return endDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

	public Integer getStatus() {
		return status;
	}

	public void setStatus(Integer status) {
		this.status = status;
	}

	public Calendar getStartTime() {
		return startTime;
	}

	public void setStartTime(Calendar startTime) {
		this.startTime = startTime;
	}

	public Integer getCompletionType() {
		return completionType;
	}

	public void setCompletionType(Integer completionType) {
		this.completionType = completionType;
	}

	public Calendar getEndTime() {
		return endTime;
	}

	public void setEndTime(Calendar endTime) {
		this.endTime = endTime;
	}

	public Long getGoalExtensionId() {
		return goalExtensionId;
	}

	public void setGoalExtensionId(Long goalExtensionId) {
		this.goalExtensionId = goalExtensionId;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public Boolean getSelected() {
		return selected;
	}

	public void setSelected(Boolean selected) {
		this.selected = selected;
	}

	public List<MyGoalTaskActivity> getMyGoalsTaskActivities() {
		return myGoalsTaskActivities;
	}

	public void setMyGoalsTaskActivities(List<MyGoalTaskActivity> myGoalsTaskActivities) {
		this.myGoalsTaskActivities = myGoalsTaskActivities;
	}

	public List<MyGoalsTaskExtensions> getMyGoalsTaskExtensions() {
		return myGoalsTaskExtensions;
	}

	public void setMyGoalsTaskExtensions(List<MyGoalsTaskExtensions> myGoalsTaskExtensions) {
		this.myGoalsTaskExtensions = myGoalsTaskExtensions;
	}

	
	public Boolean getMarkCompleted() {
		return markCompleted;
	}

	public void setMarkCompleted(Boolean markCompleted) {
		this.markCompleted = markCompleted;
	}

	public List<MyGoalTaskActivity> getTrackTaskActivities() {
		return trackTaskActivities;
	}

	public void setTrackTaskActivities(List<MyGoalTaskActivity> trackTaskActivities) {
		this.trackTaskActivities = trackTaskActivities;
	}

	@Override
	public String toString() {
		String startTimeStr = getStartHour() + ":" + getStartMinute();
		String endTimeStr = getEndHour() + ":" + getEndMinute();

		return "MyGoalTask [taskId=" + taskId + ", completedDate=" + completedDate + ", taskSequenceNumber=" + taskSequenceNumber + ", startDate=" + startDate
				+ ", taskName=" + taskName + ", description=" + description + ", taskRepetitionCycleType=" + taskRepetitionCycleType + ", endDate=" + endDate
				+ ", status=" + status + ", startTime=" + startTimeStr + ", completionType=" + completionType + ", endTime=" + endTimeStr + ", goalExtensionId="
				+ goalExtensionId + ", oplock=" + oplock + ", selected=" + selected + ", myGoalsTaskActivities=" + myGoalsTaskActivities
				+ ", myGoalsTaskExtensions=" + myGoalsTaskExtensions + "]";
	}
}
